function cf_pJT103 = cf_edge_detection_tf_fit_pJT103(pJT103_light_input_range_log10,pJT103_LacZ_output_log10)
%CREATEFIT Create plot of data sets and fits
%   CREATEFIT(IPTG_RANGE_LOG10,LACZ_OUTPUT_LOG10,PJT103_LIGHT_INPUT_RANGE_LOG10,PJT103_LACZ_OUTPUT_LOG10)
%   Creates a plot, similar to the plot in the main Curve Fitting Tool,
%   using the data that you provide as input.  You can
%   use this function with the same data you used with CFTOOL
%   or with different data.  You may want to edit the function to
%   customize the code and this help message.
%
%   Number of data sets:  2
%   Number of fits:  1

% Data from data set "LacZ_output_log10 vs. IPTG_range_log10":
%     X = IPTG_range_log10:
%     Y = LacZ_output_log10:
%     Unweighted

% Data from data set "pJT103_LacZ_output_log10 vs. pJT103_light_input_range_log10":
%     X = pJT103_light_input_range_log10:
%     Y = pJT103_LacZ_output_log10:
%     Unweighted

% Auto-generated by MATLAB on 28-Mar-2011 17:04:18

% Set up figure to receive data sets and fits
f_ = clf;
figure(f_);
set(f_,'Units','Pixels','Position',[713 302 688 485]);
% Line handles and text for the legend.
legh_ = [];
legt_ = {};
% Limits of the x-axis.
xlim_ = [Inf -Inf];
% Axes for the plot.
ax_ = axes;
set(ax_,'Units','normalized','OuterPosition',[0 0 1 1]);
set(ax_,'Box','on');
axes(ax_);
hold on;

% --- Plot data that was originally in data set "pJT103_LacZ_output_log10 vs. pJT103_light_input_range_log10"
pJT103_light_input_range_log10 = pJT103_light_input_range_log10(:);
pJT103_LacZ_output_log10 = pJT103_LacZ_output_log10(:);
h_ = line(pJT103_light_input_range_log10,pJT103_LacZ_output_log10,'Parent',ax_,'Color',[0.333333 0 0.666667],...
    'LineStyle','none', 'LineWidth',1,...
    'Marker','.', 'MarkerSize',12);
xlim_(1) = min(xlim_(1),min(pJT103_light_input_range_log10));
xlim_(2) = max(xlim_(2),max(pJT103_light_input_range_log10));
legh_(end+1) = h_;
legt_{end+1} = 'pJT103_LacZ_output_log10 vs. pJT103_light_input_range_log10';

% Nudge axis limits beyond data limits
if all(isfinite(xlim_))
    xlim_ = xlim_ + [-1 1] * 0.01 * diff(xlim_);
    set(ax_,'XLim',xlim_)
else
    set(ax_, 'XLim',[-3.0477815125038363, 1.8259327628874802]);
end

% --- Create fit "fit 6"
fo_ = fitoptions('method','NonlinearLeastSquares','Lower',[1 -2  1],'Upper',[5 2 5]);
ok_ = isfinite(pJT103_light_input_range_log10) & isfinite(pJT103_LacZ_output_log10);
if ~all( ok_ )
    warning( 'GenerateMFile:IgnoringNansAndInfs',...
        'Ignoring NaNs and Infs in data.' );
end
st_ = [2.8450000000000002 -1.1399999999999999 4.694 ];
set(fo_,'Startpoint',st_);
ft_ = fittype('Bottom+(Top-Bottom)/(1+10^(LogEC50-x))',...
    'dependent',{'y'},'independent',{'x'},...
    'coefficients',{'Bottom', 'LogEC50', 'Top'});

% Fit this model using new data
cf_pJT103 = fit(pJT103_light_input_range_log10(ok_),pJT103_LacZ_output_log10(ok_),ft_,fo_);
% Alternatively uncomment the following lines to use coefficients from the
% original fit. You can use this choice to plot the original fit against new
% data.
%    cv_ = { 3.0524211643705721, 0.590731279629785, 2.4132477246185742};
%    cf_pJT103 = cfit(ft_,cv_{:});

% Plot this fit
h_ = plot(cf_pJT103,'fit',0.95);
set(h_(1),'Color',[1 0 0],...
    'LineStyle','-', 'LineWidth',2,...
    'Marker','none', 'MarkerSize',6);
% Turn off legend created by plot method.
legend off;
% Store line handle and fit name for legend.
legh_(end+1) = h_(1);
legt_{end+1} = 'fit 6';

% --- Finished fitting and plotting data. Clean up.
hold off;
% Display legend
leginfo_ = {'Orientation', 'vertical'};
h_ = legend(ax_,legh_,legt_,leginfo_{:});
set(h_,'Units','normalized');
t_ = get(h_,'Position');
t_(1:2) = [0.2,0.15];
set(h_,'Interpreter','none','Position',t_);
% Setup labels for x- and y-axes.
xlabel(ax_,'Light');
ylabel(ax_,'LacZ');
